/**
 * \file: AudioSinkChannel.h
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * <brief description>.
 * <detailed description>
 * \component: Android Auto
 *
 * \author: I. Hayashi / ADITJ/SW / ihayashi@jp.adit-jv.com
 *
 * \copyright (c) 2014-2015 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 * \see <related items>
 *
 * \history
 *
 ***********************************************************************/

#ifndef AAUTO_AUDIOSINK_CHANNEL_H
#define AAUTO_AUDIOSINK_CHANNEL_H

#include <adit_logging.h>
#include "aauto/AautoErrorCodes.h"

/* GalReceiver headers */
#include <aauto/GalReceiver.h>
#include <aauto/util/shared_ptr.h>

#include "aauto/AditAudioSink.h"

#include "utils/IConfiguration.h"

namespace adit { namespace aauto {

class AudioSinkChannel : public IAditAudioSinkCallbacks
{
public:
    AudioSinkChannel(::shared_ptr<GalReceiver> inReceiver, uint8_t inSessionId,
        AudioStreamType inStreamType, IDynamicConfiguration& inConfig);
    ~AudioSinkChannel();

    bool Initialize();
    void shutdown();
    void playbackStartCallback(int32_t sessionId);
    void playbackStopCallback(int32_t sessionId);
    void notifyErrorCallback(aautoErrorCodes inErrorCode);

private:
    ::shared_ptr<GalReceiver> receiver;
    uint8_t sessionId;
    int mStreamType;
    IDynamicConfiguration* mConfig;

    ::shared_ptr<AditAudioSink> endpoint;
};

} } /* namespace adit { namespace aauto */

#endif /* AAUTO_AUDIOSINK_CHANNEL_H */
